/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.google.common.collect.ImmutableMap;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseBlockPropertyHolder;
import com.voxelutopia.ultramarine.world.block.RailingSlant;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RailingBlock
extends Block
implements BaseBlockPropertyHolder,
SimpleWaterloggedBlock {
    protected final BaseBlockProperty property;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<Direction, VoxelShape> shapeByPart;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty SHIFTED = ModBlockStateProperties.SHIFTED;
    public static final BooleanProperty POLE_LOCKED = ModBlockStateProperties.LOCKED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape MARBLE_POLE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)22.0, (double)10.0);
    private static final VoxelShape MARBLE_NORTH_SIDE = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)15.0, (double)9.0);
    private static final VoxelShape MARBLE_SOUTH_SIDE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)15.0, (double)16.0);
    private static final VoxelShape MARBLE_WEST_SIDE = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0);
    private static final VoxelShape MARBLE_EAST_SIDE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0);
    public static final Map<Direction, VoxelShape> MARBLE_SHAPES = Map.of(Direction.UP, MARBLE_POLE, Direction.NORTH, MARBLE_NORTH_SIDE, Direction.SOUTH, MARBLE_SOUTH_SIDE, Direction.WEST, MARBLE_WEST_SIDE, Direction.EAST, MARBLE_EAST_SIDE);
    private static final VoxelShape WOODEN_POLE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    private static final VoxelShape WOODEN_NORTH_SIDE = Block.m_49796_((double)7.5, (double)2.5, (double)0.0, (double)8.5, (double)12.0, (double)8.5);
    private static final VoxelShape WOODEN_SOUTH_SIDE = Block.m_49796_((double)7.5, (double)2.5, (double)7.5, (double)8.5, (double)12.0, (double)16.0);
    private static final VoxelShape WOODEN_WEST_SIDE = Block.m_49796_((double)0.0, (double)2.5, (double)7.5, (double)8.5, (double)12.0, (double)8.5);
    private static final VoxelShape WOODEN_EAST_SIDE = Block.m_49796_((double)7.5, (double)2.5, (double)7.5, (double)16.0, (double)12.0, (double)8.5);
    public static final Map<Direction, VoxelShape> WOODEN_SHAPES = Map.of(Direction.UP, WOODEN_POLE, Direction.NORTH, WOODEN_NORTH_SIDE, Direction.SOUTH, WOODEN_SOUTH_SIDE, Direction.WEST, WOODEN_WEST_SIDE, Direction.EAST, WOODEN_EAST_SIDE);

    public RailingBlock(BaseBlockProperty property, Map<Direction, VoxelShape> partShapes) {
        super(property.properties.m_60955_());
        this.property = property;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SHIFTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POLE_LOCKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeByPart = partShapes;
        this.shapeByIndex = this.makeShapes();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level levelreader = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        BlockPos northSide = blockpos.m_122012_();
        BlockPos eastSide = blockpos.m_122029_();
        BlockPos southSide = blockpos.m_122019_();
        BlockPos westSide = blockpos.m_122024_();
        BlockState northState = levelreader.m_8055_(northSide);
        BlockState eastState = levelreader.m_8055_(eastSide);
        BlockState southState = levelreader.m_8055_(southSide);
        BlockState westState = levelreader.m_8055_(westSide);
        boolean north = this.connectsTo(northState, northState.m_60783_((BlockGetter)levelreader, northSide, Direction.SOUTH));
        boolean east = this.connectsTo(eastState, eastState.m_60783_((BlockGetter)levelreader, eastSide, Direction.WEST));
        boolean south = this.connectsTo(southState, southState.m_60783_((BlockGetter)levelreader, southSide, Direction.NORTH));
        boolean west = this.connectsTo(westState, westState.m_60783_((BlockGetter)levelreader, westSide, Direction.EAST));
        boolean up = !(east && west && !north && !south || !east && !west && north && south);
        BlockState waterState = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)waterState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(up));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        boolean north = (Boolean)pState.m_61143_((Property)NORTH);
        boolean south = (Boolean)pState.m_61143_((Property)SOUTH);
        boolean east = (Boolean)pState.m_61143_((Property)EAST);
        boolean west = (Boolean)pState.m_61143_((Property)WEST);
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (pFacing == Direction.DOWN || pFacing == Direction.UP) {
            return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        if (pFacing == Direction.NORTH) {
            north = this.connectsTo(pFacingState, pFacingState.m_60783_((BlockGetter)pLevel, pFacingPos, Direction.SOUTH));
        }
        if (pFacing == Direction.SOUTH) {
            south = this.connectsTo(pFacingState, pFacingState.m_60783_((BlockGetter)pLevel, pFacingPos, Direction.NORTH));
        }
        if (pFacing == Direction.EAST) {
            east = this.connectsTo(pFacingState, pFacingState.m_60783_((BlockGetter)pLevel, pFacingPos, Direction.WEST));
        }
        if (pFacing == Direction.WEST) {
            west = this.connectsTo(pFacingState, pFacingState.m_60783_((BlockGetter)pLevel, pFacingPos, Direction.EAST));
        }
        boolean up = (Boolean)pState.m_61143_((Property)POLE_LOCKED) != false || (!east || !west || north || south) && (east || west || !north || !south);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(up));
    }

    public BlockState updatePole(BlockState state) {
        boolean north = (Boolean)state.m_61143_((Property)NORTH);
        boolean south = (Boolean)state.m_61143_((Property)SOUTH);
        boolean east = (Boolean)state.m_61143_((Property)EAST);
        boolean west = (Boolean)state.m_61143_((Property)WEST);
        boolean up = (Boolean)state.m_61143_((Property)POLE_LOCKED) != false || (!east || !west || north || south) && (east || west || !north || !south);
        return (BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(up));
    }

    private boolean connectsTo(BlockState pState, boolean pSideSolid) {
        return pState.m_60713_((Block)this) || pState.m_60734_() instanceof RailingSlant || !RailingBlock.m_152463_((BlockState)pState) && pSideSolid;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeByIndex.get(pState);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.m_5940_(pState, pLevel, pPos, pContext);
    }

    private Map<BlockState, VoxelShape> makeShapes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean up : UP.m_6908_()) {
            for (Boolean east : EAST.m_6908_()) {
                for (Boolean north : NORTH.m_6908_()) {
                    for (Boolean west : WEST.m_6908_()) {
                        for (Boolean south : SOUTH.m_6908_()) {
                            VoxelShape shape = Shapes.m_83040_();
                            if (north.booleanValue()) {
                                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.shapeByPart.get(Direction.NORTH));
                            }
                            if (south.booleanValue()) {
                                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.shapeByPart.get(Direction.SOUTH));
                            }
                            if (east.booleanValue()) {
                                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.shapeByPart.get(Direction.EAST));
                            }
                            if (west.booleanValue()) {
                                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.shapeByPart.get(Direction.WEST));
                            }
                            if (up.booleanValue()) {
                                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.shapeByPart.get(Direction.UP));
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)up)).m_61124_((Property)EAST, (Comparable)east)).m_61124_((Property)WEST, (Comparable)west)).m_61124_((Property)NORTH, (Comparable)north)).m_61124_((Property)SOUTH, (Comparable)south);
                            for (Boolean shifted : SHIFTED.m_6908_()) {
                                for (Boolean locked : POLE_LOCKED.m_6908_()) {
                                    for (Boolean waterlogged : WATERLOGGED.m_6908_()) {
                                        blockstate = (BlockState)((BlockState)((BlockState)blockstate.m_61124_((Property)SHIFTED, (Comparable)shifted)).m_61124_((Property)POLE_LOCKED, (Comparable)locked)).m_61124_((Property)WATERLOGGED, (Comparable)waterlogged);
                                        builder.put((Object)blockstate, (Object)shape);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{UP, NORTH, SOUTH, EAST, WEST, SHIFTED, POLE_LOCKED, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) == false;
    }

    @Override
    public BaseBlockProperty getProperty() {
        return this.property;
    }
}

